<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>{{trans("crudbooster.page_title_login")}} : {{Session::get('appname')}}</title>
    <meta name='generator' content='CRUDBooster'/>
    <meta name='robots' content='noindex,nofollow'/>
    <link rel="shortcut icon"
          href="{{ CRUDBooster::getSetting('favicon')?asset(CRUDBooster::getSetting('favicon')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}">

    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.2 -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- Font Awesome Icons -->
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <!-- Theme style -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/dist/css/AdminLTE.min.css')}}" rel="stylesheet" type="text/css"/>

    <!-- support rtl-->
    @if (in_array(App::getLocale(), ['ar', 'fa']))
        <link rel="stylesheet" href="//cdn.rawgit.com/morteza/bootstrap-rtl/v3.3.4/dist/css/bootstrap-rtl.min.css">
        <link href="{{ asset("vendor/crudbooster/assets/rtl.css")}}" rel="stylesheet" type="text/css"/>
@endif

<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->

    <link rel='stylesheet' href='{{asset("vendor/crudbooster/assets/css/main.css")}}'/>
    <style type="text/css">
        .login-page, .register-page {
            background: {{ CRUDBooster::getSetting("login_background_color")?:'#dddddd'}} url('{{ CRUDBooster::getSetting("login_background_image")?asset(CRUDBooster::getSetting("login_background_image")):asset('vendor/crudbooster/assets/bg_blur3.jpg') }}');
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#ffffff' }}  !important;
            background-repeat: no-repeat;
            background-position: center;
            background-size: cover;
        }

        .login-box, .register-box {
            margin: 1% auto;
        }

        .login-box-body {
            box-shadow: 0px 0px 50px rgba(0, 0, 0, 0.8);
            background: rgba(255, 255, 255, 0.9);
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#666666' }}  !important;
        }

        html, body {
            overflow: hidden;
        }
    </style>
</head>

<body class="login-page">

<div class="login-box">
    <div class="login-logo" style="margin-bottom:-10px;">
        <a href="{{url('/')}}">
            <img title='{!!(Session::get('appname') == 'CRUDBooster')?"<b>CRUD</b>Booster":CRUDBooster::getSetting('appname')!!}'
                 src='{{ CRUDBooster::getSetting("logo")?asset(CRUDBooster::getSetting('logo')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}'
                 style='max-width: 100%;height:30px'/>
        </a>
    </div><!-- /.login-logo -->
	<br>
    <div class="login-box-body">

        @if ( Session::get('message') != '' )
            <div class='alert alert-warning'>
                {{ Session::get('message') }}
            </div>
        @endif

        <p class='login-box-msg' id="title">Registrasi Pengguna</p>
        <form autocomplete='off' action="javascript:cariLokal();" method="post" id="regform">
            <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
            <div class="form-group has-feedback">
                <input autocomplete='off' type="text" id="niplog" class="form-control" name='nip' required placeholder="Masukkan NIK Anda"/>
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
            </div>
            <div style="margin-bottom:10px" class='row'>
                <div class='col-xs-12'>
                    <button class="btn btn-primary btn-block btn-flat"><i class='fa fa-lock'></i> Next</button>
                </div>
            </div>
        </form>


        <br/>
        <!--a href="#">I forgot my password</a-->

    </div><!-- /.login-box-body -->

</div><!-- /.login-box -->


	
<!-- jQuery 2.1.3 -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/plugins/jQuery/jQuery-2.1.4.min.js')}}"></script>
<!-- Bootstrap 3.3.2 JS -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/js/bootstrap.min.js')}}" type="text/javascript"></script>
<!--- <script src="{{asset('js/jquery.validate.js')}}"></script> -->
<script type="text/javascript">

	sessionStorage.host = "http://192.168.200.251/siapkk/public";

	
	//alert( 'afu' );
	function cariLokal(){
		if($("#niplog").val()!==""){
			sessionStorage.selNip=$("#niplog").val();
				$.ajax({
					type: "POST",
					url: sessionStorage.host+ "/api/cari_lokal",
					cache: false,
					data: "nik="+sessionStorage.selNip,
					success: function (result) {
						//alert(result);	
						cariIni(sessionStorage.selNip);						
					},
					error: function (request,error) {
						console.log(error);	
					}
				});	
		}else{
			alert('NIK TIdak Boleh Kosong !');
		}
	}
	
	function cariIni(nik){
		if($("#niplog").val()!==""){
			$("#title").html('Yang Mana Anda ?');
			sessionStorage.selNip=$("#niplog").val();
			$("#regform").empty();
			var recode = '';
			var cnt = 0;
				$.ajax({
					type: "POST",
					url: sessionStorage.host+ "/api/pilih_nama",
					//url: "http://localhost/paten/public/api/pilih_nama",
					cache: false,
					//data: "nip="+sessionStorage.selNip,
					data: "nik="+sessionStorage.selNip,
					success: function (result) {
						
						//var res = jQuery.parseJSON(result);
						//alert(res);
						var res = result;
						$.each(res.nama_lgkp, function(key,value){
							//console.log(value.tmpt);
							var namacmd = "'" + value.nama + "'";
							recode += '<button class="btn btn-primary btn-block btn-flat" onclick="cariIbu('+namacmd+');">'+value.nama+'</button>';
							cnt++;
						});
						
						$("#regform").append(recode);
						//$(".regform").listview("refresh");
						
						
					},
					error: function (request,error) {
						console.log(error);	
					}
				});	
		}else{
			alert('NIK TIdak Boleh Kosong !');
		}
	}
	
	function cariIbu(nama){
		$("#title").html('Nama Ibu Anda ?');
		sessionStorage.selNama=nama;
		$("#regform").empty();
		var recode = '';
		var cnt = 0;
		$.ajax({
			type: "POST",
			url: sessionStorage.host+ "/api/capil",
			cache: false,
			data: "nik="+sessionStorage.selNip,
			success: function (result) {
				
				var res = result;

				$.each(res.nama_ibu, function(key,value){
					//alert(value.tmpt);
					
					var tmptcmd = "'" + value.nama+ "'";
					recode += '<button class="btn btn-primary btn-block btn-flat" style="height:50px;margin-bottom:4px;white-space: normal;"" onclick="simpanTempat('+tmptcmd+');">'+value.nama+'</button>';
					cnt++;
				});
				//alert(recode);
				$("#regform").append(recode);		
				
			},
			error: function (request,error) {
				console.log(error);	
			}
		});		
	}
	
	function cariAlamat(nama){
		$("#title").html('Dimana Anda Tinggal ?');
		sessionStorage.selNama=nama;
		$("#regform").empty();
		var recode = '';
		var cnt = 0;
		$.ajax({
			type: "POST",
			url: sessionStorage.host+ "/api/pilih_alamat",
			//url: "http://localhost/paten/public/api/pilih_alamat",
			cache: false,
			data: "nik="+sessionStorage.selNip,
			success: function (result) {
				
				var res = result;

				$.each(res.alamat, function(key,value){
					//alert(value.tmpt);
					
					var tmptcmd = "'" + value.alamat + "'";
					recode += '<button class="btn btn-primary btn-block btn-flat" style="height:50px;margin-bottom:4px;white-space: normal;"" onclick="simpanTempat('+tmptcmd+');">'+value.alamat+'</button>';
					cnt++;
				});
				//alert(recode);
				$("#regform").append(recode);		
				
			},
			error: function (request,error) {
				console.log(error);	
			}
		});		
	}
	
	function simpanTempat(alamat){
		$("#title").html('Password Yang Anda Inginkan');
		sessionStorage.selAlamat = alamat;
		cariWilayah();
		$("#regform").empty();
		var logcmd = "{{ route('postRegister') }}";
		var recode = '';
		
		recode += '<form autocomplete="off" action="' + logcmd + '" method="post" id="lastform">';
		recode += '<input type="hidden" name="_token" value="{{ csrf_token() }}"/>';
		recode += '<div class="form-group has-feedback">';
        recode +=      '<input autocomplete="off" type="text" id="nik" class="form-control" name="nik" required placeholder="NIK" value="' + sessionStorage.selNip + '"/>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode += '</div>';
		recode += '<div class="form-group has-feedback">';
        recode +=      '<input autocomplete="off" type="text" id="name" class="form-control" name="name" required placeholder="Nama" value="' + sessionStorage.selNama + '"/>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode += '</div>';
		recode += '</div>';
		recode += '<div class="form-group has-feedback">';
        recode +=      '<input autocomplete="off" type="text" id="alamat" class="form-control" name="alamat" required placeholder="Nama Ibu" value="' + sessionStorage.selAlamat + '"/>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode += '</div>';
		recode += '<div class="form-group has-feedback" hidden>';
        recode +=      '<textarea autocomplete="off" type="text" id="talamat" class="form-control" name="talamat" required placeholder="Alamat">'+sessionStorage.selAlamat+'</textarea>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode += '</div>';
		recode += '<div class="form-group has-feedback" hidden>';
        recode +=      '<input autocomplete="off" type="text" id="nama_kec" class="form-control" name="nama_kec" required placeholder="Kecamatan" value="' + sessionStorage.selNamaKec + '"/>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode += '</div>';
		
		recode += '<div class="form-group has-feedback" hidden>';
        recode +=      '<input autocomplete="off" type="text" id="district_id" class="form-control" name="district_id" required placeholder="district id" value="' + sessionStorage.selDistrict + '"/>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode += '</div>';
		
		recode += '<div class="form-group has-feedback" hidden>';
        recode +=      '<input autocomplete="off" type="text" id="nama_kel" class="form-control" name="nama_kel" required placeholder="Kelurahan" value="' + sessionStorage.selNamaKel + '"/>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode += '</div>';
		
		recode += '<div class="form-group has-feedback" hidden>';
        recode +=      '<input autocomplete="off" type="text" id="village_id" class="form-control" name="village_id" required placeholder="village id" value="' + sessionStorage.selVillage + '"/>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode += '</div>';
		
		recode += '<div class="form-group has-feedback">';
        recode +=      '<input autocomplete="off" type="password" id="password" class="form-control" name="password" required placeholder="Ketikan Password"/>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode += '</div>';
		recode += '<div class="form-group has-feedback">';
        recode +=     '<input autocomplete="off" type="password" id="repassword" class="form-control" name="repassword" required placeholder="Ketikan Password Sekali Lagi"/>';
        recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
        recode +=  '</div>';
        recode +=    '<div style="margin-bottom:10px" class="row" >';
        recode +=        '<div class="col-xs-12">';
        recode +=            '<button type="submit" class="btn btn-primary btn-block btn-flat"><i class="fa fa-lock"></i> Daftar</button>';
        recode +=        '</div>';
        recode +=    '</div>';
		recode += '</form>';
		
		$("#regform").replaceWith(recode);	
		
		asin();
		
		//$("#nik").val(sessionStorage.selNip);
		//$("#name").val(sessionStorage.selNama);
		//$("#nama_kec").val(sessionStorage.selNamaKec);
		//$("#nama_kel").val(sessionStorage.selNamaKel);
		
		// if($("#passwordreg").val() !== ""){
			// if($("#passwordreg").val() == $("#repasswordreg").val()){
				
				// simpanRegistrasi();
			// }else{
				// alert('password tidak sama !');
			// }
		// }else{
			// alert("Harap isi password !");
		// }
	}
	
	function cariWilayah(){
		sessionStorage.selNamaKec = "";
		sessionStorage.selNamaKel = "";
		sessionStorage.selDistrict = "";
		sessionStorage.selVillage = "";
		$.ajax({
			type: "POST",
			url: sessionStorage.host+ "/api/cari_wilayah",
			//url: "http://localhost/paten/public/api/cari_wilayah",
			data: "nik="+sessionStorage.selNip+"&nama_lgkp="+sessionStorage.selNama+"&ibu="+sessionStorage.selAlamat ,
			async: false,
			cache: false,
			timeout: 7000,
			success: function (result) {
				
				var res = result;
				//alert(res.nama_kec);
				sessionStorage.selNamaKec = res.kecamatan;
				sessionStorage.selNamaKel = res.kelurahan;
				sessionStorage.selDistrict = res.nama_kec;
				sessionStorage.selVillage = res.nama_kel;

	
				
			},
			error: function (request,error) {
				console.log(error);	
			}
		});	
	}
	
	function asin(){
		$('#lastform').submit(function(e) { 
			if($('#password').val().length >=5){
				if($('#password').val() != $('#repassword').val()){
					alert('Password harus sama !');
					e.preventDefault(); // Cancel the submit
					return false; // Exit the .each loop
				}
			}else{
				alert('Minimal 5 karakter !');
				e.preventDefault(); // Cancel the submit
				return false; // Exit the .each loop
			}
		});
	}

</script>
</body>
</html>